/* ------------------------------------------------------------------------------
  File: chr6dm_HMC.c
  Author: CH Robotics
  Version: 1.0
  
  Description: Functions for interacting with HMC5843 magnetic sensor
------------------------------------------------------------------------------ */ 

#include "stm32f10x.h"
#include "CHR_i2c.h"
#include "CHR_HMC.h"

uint8_t gHMC_Initialized = 0;

/*******************************************************************************
* Function Name  : initializeHMC
* Input          : None
* Output         : uint8_t* status_flag
* Return         : 1 if success, 0 if fail
* Description    : Sets the configuration registers of the HMC.  The registers
						 are set in an order that guarantees that the next register
						 accessed during a read will be 0x03 (i.e. getHMCData can be called
						 after initializeHMC is called.
						 
						 If the function succesfully initializes the HMC, then
						 the return value is 1.  If failed, then the function returns 0,
						 and status_flag is filled with one of the following error codes:
						 
						 HMC_REG0_FAILED => Couldn't set register 0
						 HMC_REG1_FAILED => Couldn't set register 1
						 HMC_REG2_FAILED => Couldn't set register 2
						 
*******************************************************************************/
int32_t initializeHMC( uint8_t* status_flag )
{	 
	 uint8_t returnval;
	 
	 // Set mag. update frequency to 50 Hz
	 g_i2cTxBuf[0] = 0x00;	 
	 g_i2cTxBuf[1] = 0x18;		// 50 Hz
//	 g_i2cTxBuf[1] = 0x04;	// 1 Hz
//	 g_i2cTxBuf[1] = 0x08;	// 2 Hz
//	 g_i2cTxBuf[1] = 0x0C;	// 5 Hz
//	 g_i2cTxBuf[1] = 0x10;	// 10 Hz
	 
	 /*
	 g_i2cCurrentSlaveAddress = MAG_SLAVE_ADDRESS7;
	 g_i2cDirection = I2C_TRANSMITTER;
	 g_i2cBytesToTransmit = 2;
	 g_i2cReadPrelude = 0;
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 */
	 
	 returnval = i2cBatchWrite( MAG_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );

	 	 
	 // Set gain setting on mag. sensor
	 g_i2cTxBuf[0] = 0x01;
//	 g_i2cTxBuf[1] = 0xC0;		// +/- 4.5 Gauss
//	 g_i2cTxBuf[1] = 0xA0;		// +/- 3.8 Gauss
//	 g_i2cTxBuf[1] = 0x80;		// +/- 3.2 Gauss
	 g_i2cTxBuf[1] = 0x60;		// +/- 2 Gauss
//	 g_i2cTxBuf[1] = 0x40;		// +/- 1.5 Gauss
//	 g_i2cTxBuf[1] = 0x20;		// +/- 1.0 Gauss
//	 g_i2cTxBuf[1] = 0x00;		// +/- 0.7 Gauss
	 
	 /*
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 */
	 
	 returnval = i2cBatchWrite( MAG_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );
	 
	 // Set magnetometer to run in continuous mode
	 g_i2cTxBuf[0] = 0x02;
	 g_i2cTxBuf[1] = 0x00;
	 
	 /*
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 */
	 
	 returnval = i2cBatchWrite( MAG_SLAVE_ADDRESS7, g_i2cTxBuf, 2 );
	 
	 gHMC_Initialized = 1;
	 
	 return 1;
}

/*******************************************************************************
* Function Name  : getHMCData
* Input          : None
* Output         : None
* Return         : 1 if success, 0 if fail
* Description    : Fills g_i2cRxBuf with 7 bytes of data - the first 6 bytes are
						 the magnetic readings from the x, y, and z axes (respectively)
						 of the HMC5843, while the last byte is the HMC status register.
						 This function call assumes that the internal register address
						 pointer of the HMC is set to register 0x03.
*******************************************************************************/
int32_t getHMCData( )
{
	 int i;
	 
	 i2cBatchRead( MAG_SLAVE_ADDRESS7, 0x03, g_i2cRxBuf, 6 );
	 
	 return 1;
	 
	 /*
	 g_i2cTxBuf[0] = 0x03;
	 g_i2cCurrentSlaveAddress = MAG_SLAVE_ADDRESS7;
	 g_i2cDirection = I2C_TRANSMITTER;
	 g_i2cBytesToTransmit = 1;
	 g_i2cReadPrelude = 1;
	 i2cStart();
	 
	 g_i2cCurrentSlaveAddress = MAG_SLAVE_ADDRESS7;
	 g_i2cDirection = I2C_RECEIVER;
	 g_i2cBytesToReceive = 6;
	 g_i2cReadPrelude = 0;
	 i2cStart();
	 
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 else
	 {		  
		  return 1;
	 }
	 */
		  
}

